/**INC+***********************************************************************/
/* Header:    randstrc.h                                                     */
/*                                                                           */
/* Purpose:   Randbot structures.                                            */
/*                                                                           */
/* Copyright (c) 2002 - 2005 Andrew Rose.  All rights reserved.              */
/*                                                                           */
/**INC-***********************************************************************/

#ifndef RANDSTRC_INCLUDED
#define RANDSTRC_INCLUDED

/**STRUCT+********************************************************************/
/* Structure: RAND_MSG                                                       */
/*                                                                           */
/* Description: Structure used to hold messages waiting to be processed by   */
/*            the randbot.  The message data follows immediately after this  */
/*            control block.                                                 */
/*                                                                           */
/*****************************************************************************/

typedef struct rand_msg
{
  /***************************************************************************/
  /* Queue header.                                                           */
  /***************************************************************************/
  VOS_Q_ITEM q_hdr;

  /***************************************************************************/
  /* The length of the message.                                              */
  /***************************************************************************/
  VOS_S32 length;

  /***************************************************************************/
  /* The connection that the message was received on.                        */
  /***************************************************************************/
  VOS_S32 conn_id;

} RAND_MSG;

/**STRUCT-********************************************************************/

/**STRUCT+********************************************************************/
/* Structure: RAND_LOCAL_DATA                                                */
/*                                                                           */
/* Description: Local randbot data.                                          */
/*                                                                           */
/*****************************************************************************/

typedef struct rand_local_data
{
  /***************************************************************************/
  /* The AI Utility Library private data.                                    */
  /***************************************************************************/
  AIUT_DATA aiut;

  /***************************************************************************/
  /* Whether the message being processed should be freed.                    */
  /***************************************************************************/
  VOS_BOOL free_msg;

  /***************************************************************************/
  /* Whether the randbot should keep going.                                  */
  /***************************************************************************/
  VOS_BOOL keep_going;

} RAND_LOCAL_DATA;

/**STRUCT-********************************************************************/

/**STRUCT+********************************************************************/
/* Structure: RAND_THREAD_DATA                                               */
/*                                                                           */
/* Description: Data used by the main randbot thread that is passed back by  */
/*            the callback for synchronisation.                              */
/*                                                                           */
/*****************************************************************************/

typedef struct rand_thread_data
{
  /***************************************************************************/
  /* A mutex to protext access to the message queue.                         */
  /***************************************************************************/
  HANDLE mutex;

  /***************************************************************************/
  /* An semaphore to signal when there are messages on the queue to be       */
  /* processed.                                                              */
  /***************************************************************************/
  HANDLE semaphore;

  /***************************************************************************/
  /* The message queue.                                                      */
  /***************************************************************************/
  VOS_Q_ROOT msg_q;

} RAND_THREAD_DATA;

/**STRUCT-********************************************************************/

#endif

